/*
 * CRfePurRfSettings.h
 *
 *  Created on: 12.12.2011
 *      Author: stefan.detter
 */

#ifndef CRFEPURRFSETTINGS_H_
#define CRFEPURRFSETTINGS_H_

#include <QObject>
#include <QrfeTraceModule>
#include "../ui/ConfigDialog.h"

#include <QCheckBox>

class QrfeRfePurReader;
class QrfeProgressDialog;

namespace Ui
{
	class CRfePurDialogClass;
};

typedef struct
{
	ushort 	listenTime;
	ushort 	idleTime;
	ushort 	maxAllocTime;
	short 	rssiThreshold;
} LBT_PARAMS;

typedef struct
{
	uchar 		memBank;
	ulong 		address;
	uchar 		size;
	QByteArray 	mask;
} SELECTION_MASK;

typedef struct {
	QList<uint> 	frequencyList;
	uchar 			freqeuncyMaximum;
	uchar 			frequencyMode;

	LBT_PARAMS 		lbtParams;

	ushort 			uhfMaxAttenuation;
	ushort 			uhfAttenuation;
	short 			uhfMaxSensitivity;
	short 			uhfMinSensitivity;
	short 			uhfSensitivity;
	uchar 			uhfModulationDepth;

	uchar 			gen2LinkFrequency;
	uchar 			gen2Coding;
	uchar 			gen2EpcSize;
	bool 			gen2SendHandle;
    bool 			gen2SendPC;
    bool 			gen2SendRN16;
    uchar 			gen2InitialQ;
	uchar 			gen2MinimalQ;
	uchar 			gen2MaximalQ;
	uchar 			gen2QMethod;
	uchar 			gen2Session;
	uchar 			gen2InvRounds;

	SELECTION_MASK	gen2SelectionMask1;
	SELECTION_MASK	gen2SelectionMask2;

    bool            gen2CustomNxpBrandID;

} RF_SETTINGS;


class CRfePurRfSettings : public QObject, ConfigDialog, QrfeTraceModule
{
	Q_OBJECT
public:
	CRfePurRfSettings(Ui::CRfePurDialogClass* dialog, QWidget* parent);
	virtual ~CRfePurRfSettings();

	bool init ( QrfeRfePurReader* reader, QrfeProgressDialog* pb );

//public slots:
//	bool writeSettings ( );
//	void reloadSettings ( );

private:
	void loadRfSettings ( );
	bool canReadAntennaSpec ( );
	void readAntennaSpec ( );

private slots:
	void loadFrequencyProfileTable();
	void addFrequencyEntry();
	void insertInFrequencyTable(bool checked, double frequency);
	QList<uint> readFreqeuncyTable();

	void loadLbtParams(const LBT_PARAMS& params);
	void loadLbtProfileTable();
	LBT_PARAMS readLbtParams();

	void setAttenuationLabel ( int value );
	void setSensitivityLabel ( int value );
	void setModulationDepthLabel (int value );
	void setRssiThresholdLabel( int value );
	void setEpcSizeLabel ( int value );
	void setInitialSlotsLabel ( int value );
	void setMinimalSlotsLabel ( int value );
	void setMaximalSlotsLabel ( int value );
	void setSelectionMask1Editable ( bool checked );
	void setSelectionMask1Mask ( int value );
	void setSelectionMask2Editable ( bool checked );
	void setSelectionMask2Mask ( int value );

public:
	bool writeSettingsToReader( QrfeProgressDialog* pb);
	bool readSettingsFromReader( QrfeProgressDialog* pb);

private:
    Ui::CRfePurDialogClass*		m_ui;
    QWidget* 					m_parent;
	QrfeRfePurReader* 			m_reader;

	RF_SETTINGS				m_settings;

	QList<QCheckBox*>		m_frequencyCheckBoxes;

	short					m_sensitivityOffset;

	QMap<double, bool>		m_userDefinedFrequencies;
    QMap<double, bool>		m_etsiFrequencies;
    QMap<double, bool>		m_etsiUpperFrequencies;
    QMap<double, bool>		m_fcc25Frequencies;
	QMap<double, bool>		m_fcc50Frequencies;
	QMap<double, bool>		m_japanFrequencies;
	QMap<double, bool>		m_currentFrequencies;

	LBT_PARAMS				m_lbt_current;
	LBT_PARAMS				m_lbt_ETSI;
	LBT_PARAMS				m_lbt_FCC;

};

#endif /* CRFEPURRFSETTINGS_H_ */
